﻿<%@ Page Title="" Language="C#" MasterPageFile="~/Registry.master" AutoEventWireup="true" CodeFile="PatientRelatedDiagnoses.aspx.cs" Inherits="PatientRelatedDiagnoses" %>
<%@ Import  Namespace="System.Web.Security.AntiXss" %>
<asp:Content ID="Content1" ContentPlaceHolderID="head" Runat="Server">
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="ContentPlaceHolder" Runat="Server">
    <div class="breadcrumb">
        <asp:Label SkinID="DataLabel" ID = "BreadCrumbLabel" runat="server" Text="Patients > Patient Lookup > Related Diagnoses > " />
    </div> 

    <p>
    <asp:Panel runat="server" ID="pnlRelatedDiag" GroupingText="Related Diagnoses">
        <asp:GridView ID="GridViewRelatedDiagnostics" runat="server" SkinID = "Unsortable" ToolTip="To sort please click table headings."
            AutoGenerateColumns="False" AllowSorting="True" DataSourceID="ObjectDataSourceRelatedDiagnostics">
            <Columns>
                <asp:BoundField DataField="ID" HeaderText="ID" SortExpression="ID" 
                    Visible="False" />
                <asp:BoundField DataField="ICDCode" HeaderText="ICD Code" 
                    SortExpression="ICDCode" />
                <asp:BoundField DataField="ICDCodeSet" HeaderText="ICD Code Set" 
                    SortExpression="ICDCodeSet" ItemStyle-Width="15" />
                <asp:BoundField DataField="ICDCodeName" HeaderText="Description" 
                    SortExpression="ICDCodeName" />
                <asp:TemplateField HeaderText="Encounter Date" SortExpression="EncounterDate">
                    <ItemTemplate>
                        <asp:Label SkinID="DataLabel" ID="LabelEncounterDate" runat="server" Text='<%# AntiXssEncoder.HtmlEncode(Convert.ToString(Eval("EncounterDate", "{0:d}")), false) %>'></asp:Label>
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:BoundField DataField="SiteCode" HeaderText="Site Number" 
                    SortExpression="SiteCode" />
                <asp:BoundField DataField="FacilityName" HeaderText="Facility Name" 
                    SortExpression="FacilityName" />
            </Columns>
            
            <EmptyDataTemplate>
                        <div style="width:100%"><span>No Records Available.</span> </div>
                        </EmptyDataTemplate>
        </asp:GridView></asp:Panel>
        <asp:ObjectDataSource ID="ObjectDataSourceRelatedDiagnostics" runat="server" 
            OldValuesParameterFormatString="original_{0}" SelectMethod="SelectByPatientID" 
            SortParameterName="sort"
            TypeName="VeteransAffairs.Registries.BusinessManager.RelatedDiagnosticsManager">
            <SelectParameters>
                <asp:QueryStringParameter DefaultValue="0" Name="PatientID" 
                    QueryStringField="patientid" Type="Int32" />
                <asp:Parameter Name="sort" Type="String" />
            </SelectParameters>
        </asp:ObjectDataSource>
    </p>
    <p>
        <asp:Button 
            runat = "server" 
            Text = "Back" 
            Width = "130px" 
            ID = "CancelButton" 
            OnClick="ButtonBack_OnClick" 
            ToolTip="Click to go to previous screen" 
            UseSubmitBehavior = "false" />
    </p>
    <br />
    <br />
    <br />
    <br />
    <br />
    <br />
</asp:Content>

